/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigStatusRender;
import filenet.vw.toolkit.admin.property.base.VWConfigSystemFieldSelectionDialog;
import filenet.vw.toolkit.admin.property.base.VWConfigSystemFieldTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWConfigSystemFieldPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWSession m_session = null;
    private Frame m_parentFrame = null;
    private IVWTableDefinition m_tableDef = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_fieldTable = null;
    private VWConfigSystemFieldTableModel m_fieldTableModel = null;
    private int m_dbType;

    public VWConfigSystemFieldPanel(Frame parent, VWSession session, IVWTableDefinition tableDef) {
        try {
            this.m_parentFrame = parent;
            this.m_session = session;
            this.m_dbType = this.m_session.getDatabaseType();
            this.m_tableDef = tableDef;
            this.createControls(VWResource.SystemFields, 0x10000010);
            this.m_fieldTable.clearSelection();
            this.m_fieldTable.setRowSelectionInterval(0, 0);
            this.m_fieldTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this, parent, VWResource.SystemFieldsPanel, VWResource.SystemFieldsPanel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isModified() {
        if (this.m_fieldTableModel != null) {
            return this.m_fieldTableModel.isModified();
        }
        return false;
    }

    public void stopEditing() {
        if (this.m_fieldTable != null) {
            this.m_fieldTable.stopEditing();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 1: {
                this.updateTableSelection(event.getLastRow() - 1, true);
                break;
            }
            case -1: {
                this.updateTableSelection(event.getLastRow() - 1, false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nFirstIndex = this.m_fieldTable.getSelectionModel().getMinSelectionIndex();
            int nLastIndex = this.m_fieldTable.getSelectionModel().getMaxSelectionIndex();
            if (nFirstIndex == -1 || nLastIndex == -1) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            } else {
                boolean bEnableDelete = false;
                for (int i = nFirstIndex; i <= nLastIndex; ++i) {
                    if (!this.m_fieldTableModel.getCanDeleteRow(i)) continue;
                    bEnableDelete = true;
                    break;
                }
                if (bEnableDelete) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
                } else {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                }
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.onUpdateRows();
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_session = null;
        this.m_parentFrame = null;
        this.m_tableDef = null;
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseResources();
            this.m_toolBarBorder.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_toolBarBorder = null;
        }
        if (this.m_fieldTable != null) {
            this.m_fieldTable.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_fieldTable.removeAll();
            this.m_fieldTable = null;
        }
        if (this.m_fieldTableModel != null) {
            this.m_fieldTableModel.releaseResources();
            this.m_fieldTableModel = null;
        }
        this.removeAll();
    }

    private void createControls(String description, int nFlags) {
        JPanel panel = null;
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_toolBarBorder = new VWToolbarBorder(description, nFlags);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_toolBarBorder.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.add((Component)this.m_toolBarBorder, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_toolBarBorder, this, description, description);
            this.createFieldTable();
            VWAccessibilityHelper.setAccessibility(this.m_fieldTable, this, description, description);
            VWAccessibilityHelper.setLabelFor(new JLabel(description), this.m_fieldTable);
            panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_fieldTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_fieldTable, panel, VWResource.FieldTable, VWResource.FieldTable);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createFieldTable() {
        int nColWidth = 0;
        try {
            this.m_fieldTableModel = new VWConfigSystemFieldTableModel(this.m_parentFrame, this.m_tableDef, this.m_session);
            this.m_fieldTableModel.addTableModelListener(this);
            this.m_fieldTable = new VWTable(this.m_fieldTableModel);
            this.m_fieldTable.setRowSelectionAllowed(true);
            this.m_fieldTable.getSelectionModel().addListSelectionListener(this);
            this.m_fieldTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_fieldTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn aColumn = this.m_fieldTable.getColumnModel().getColumn(0);
            try {
                nColWidth = Integer.valueOf("20");
            }
            catch (Exception ex) {
                nColWidth = 20;
            }
            aColumn.setMaxWidth(nColWidth);
            aColumn.setCellRenderer(new VWConfigStatusRender(0));
            aColumn = this.m_fieldTable.getColumnModel().getColumn(1);
            try {
                nColWidth = Integer.valueOf("250");
            }
            catch (Exception ex) {
                nColWidth = 250;
            }
            aColumn.setMinWidth(nColWidth);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateRows() {
        try {
            String[] availableFields = this.m_fieldTableModel.getAvailableFields();
            String[] selectedFields = this.m_fieldTableModel.getSelectedFields();
            VWConfigSystemFieldSelectionDialog dlg = new VWConfigSystemFieldSelectionDialog(this.m_parentFrame, availableFields, selectedFields);
            dlg.show();
            if (dlg.getReturnStatus() == 0 && dlg.isModified()) {
                this.m_fieldTableModel.setSelectedFields(dlg.getSelectedItems());
            }
            dlg.releaseResources();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.m_fieldTable.stopEditing();
            int[] rows = this.m_fieldTable.getSelectedRows();
            int sz = rows.length;
            if (sz > 1) {
                for (int nIndex = sz - 1; nIndex >= 0; --nIndex) {
                    String fieldName = (String)this.m_fieldTableModel.getValueAt(rows[nIndex], 1);
                    if (fieldName == null || fieldName.length() == 0) {
                        this.m_fieldTableModel.deleteItem(rows[nIndex]);
                        continue;
                    }
                    if (!this.m_fieldTableModel.getCanDeleteRow(rows[nIndex])) {
                        JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.CanNotDeleteSystemField.toString(fieldName), null, 1);
                        continue;
                    }
                    int ret = 0;
                    if (!bYesToAll) {
                        Object[] options1 = new Object[]{VWResource.Yes, VWResource.YesToAll, VWResource.No};
                        ret = JOptionPane.showOptionDialog(this.m_parentFrame, VWResource.ConfirmDeleteField.toString(fieldName), null, -1, 3, null, options1, options1[1]);
                        if (ret == 1) {
                            bYesToAll = true;
                        }
                    }
                    if (ret != 0 && !bYesToAll) continue;
                    this.m_fieldTableModel.deleteItem(rows[nIndex]);
                }
            } else {
                String fieldName;
                VWExposedFieldDefinition fieldDef = this.m_fieldTableModel.getFieldItemAt(rows[0]);
                if (fieldDef != null && VWMessageDialog.showConfirmDialog(this.m_parentFrame, VWResource.ConfirmDeleteField.toString(fieldName = fieldDef.getName()), VWResource.ConfirmDeleteField.toString(fieldName), 3) == 1) {
                    this.m_fieldTableModel.deleteItem(rows[0]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateTableSelection(int nRow, boolean bInsert) {
        if (nRow < 0) {
            nRow = 0;
        }
        if (nRow == this.m_fieldTable.getSelectedRow()) {
            this.m_fieldTable.clearSelection();
        }
        this.m_fieldTable.setRowSelectionInterval(nRow, nRow);
        if (bInsert) {
            this.m_fieldTable.ensureRowIsVisible(nRow);
        }
    }
}

